/*
  SD card read/write
 
 This example shows how to read and write data to and from an SD card file 	
 The circuit:
 * SD card attached to SPI bus as follows:
 ** MOSI - pin 11
 ** MISO - pin 12
 ** CLK - pin 13
 ** CS - pin 4
 
 created   Nov 2010
 by David A. Mellis
 updated 2 Dec 2010
 by Tom Igoe
 
 This example code is in the public domain.
 	 
 */
 
#include <SD.h>

File myFile;

void setup()
{
  Serial.begin(57600);
  Serial.print("Initializing SD card...");
  // On the Ethernet Shield, CS is pin 4. It's set as an output by default.
  // Note that even if it's not used as the CS pin, the hardware SS pin 
  // (10 on most Arduino boards, 53 on the Mega) must be left as an output 
  // or the SD library functions will not work. 
   pinMode(10, OUTPUT);
   
  if (!SD.begin(10)) {
    Serial.println("initialization failed!");
    return;
  }
    
  Serial.println("initialization done.");
  if (SD.exists("t3.txt"))
  {
   Serial.println(" t3 exists");
   
  }
  else
  {
    myFile = SD.open("t2.txt", FILE_WRITE);
    Serial.println("t2 opened");
    
File myFile1;
    myFile1 = SD.open("t3.txt", FILE_WRITE);
    char initialString[] = "trackpoint, latitude, longitude, speed, heading";
    myFile1.println(initialString);
    myFile1.close();
    Serial.println("t3 opened");    
  }
  // open the file. note that only one file can be open at a time,
  // so you have to close this one before opening another.
  myFile = SD.open("test.txt", FILE_WRITE);
  
  // if the file opened okay, write to it:
  if (myFile) {
    Serial.print("Writing to test.txt...");
    char myStr[] = "testing 1, 2, 3. with a string variable";
    myFile.println(myStr);

	// close the file:
    myFile.close();
    Serial.println("done.");
  } else {
    // if the file didn't open, print an error:
    Serial.println("error opening test.txt");
  }
  
  // re-open the file for reading:
  myFile = SD.open("test.txt");
  if (myFile) {
    Serial.println("test.txt:");
    
    // read from the file until there's nothing else in it:
    while (myFile.available()) {
    	Serial.write(myFile.read());
    }
    // close the file:
    myFile.close();
  } else {
  	// if the file didn't open, print an error:
    Serial.println("error opening test.txt");
  }
  
  // re-open the file for reading:
  File myFile1 = SD.open("t3.txt");
  if (myFile1) {
    Serial.println("t3.txt:");
    
    // read from the file until there's nothing else in it:
    while (myFile1.available()) {
    	Serial.write(myFile1.read());
    }
    // close the file:
    myFile1.close();
  } else {
  	// if the file didn't open, print an error:
    Serial.println("error opening t3.txt");
  }
}

void loop()
{
	// nothing happens after setup
}


