/*
Test for LED and switch
Stu Sontier 8-8-2012
*/

/*

 PIN CONNECTIONS
   Switch:
    On digital pin 2
   
   LED:
    On digital pin 9
    
    Operation is dependent on button presses
    1) WAIT - After reset  - LCD shows gps info (and "Waiting" and "press to start") but nothing is logged
    2) LOGGING - If WAIT and button pressed, enter the logging state and log data to CD card. LCD shows gps info and toggles with "Logging" and "press to stop"
    3) STOPPED - If LOGGING and button pressed, enter the stopped state - logging is stopped. LCD shows gps and "Stopped" and "press to upload"
    4) UPLOAD - If STOPPED and button pressed, enter the upload state. SD card read and sent to gobetwino. At end, flash "Upload finished" for 2 seconds then go to WAIT
     * pushbutton attached to pin 2 (interrupt 0) with pullup resistor to +5V
*/

// include the necessary libraries


// declare prototypes   
void flashLED(int number); 
void switchInterruptHandler();

// variables
bool LEDOn = false;
int debounceTime = 350;    	// the debounce time; increase if the interrupt appears to trigger multiple times
volatile int operatingState = 1;	 //Four possible states 

//----------------------------------------------
//----------------------------------------------
void setup()
{
  pinMode(9, OUTPUT);            // use this pin to light an led when FIX
  pinMode(2, INPUT);		// for the switch
  
  attachInterrupt(0, switchInterruptHandler, FALLING);  // switch on interrupt 0 (pin 2);
  

  Serial.begin(57600);

  Serial.println("Testing LED!");
  flashLED(12);    // flash the LED a few times to show we have got to the loop and are ready to look for GPS
}

//----------------------------------------------
//----------------------------------------------
void loop()
{

  // first time through, we're in the WAIT state
  // State only changes at start of each loop (ie interrupt function is only to flag a required state change, not operate on it - this avoids the interrupt causing unexpected behaviour when return fro minterrupt)

    unsigned long start = millis();
  

       // digitalWrite(9, LEDOn);   // set the LED to alternate

      // digitalWrite(9, LOW);   // set the LED off



    // various operations based on state
    switch (operatingState) 
    {
      case (1) :
      
        flashLED(2); 
      break;
      case (2) :
        flashLED(4); 
      break;
      case (3) :
        flashLED(6); 
      break;
      case (4) :
        flashLED(8); 
      break;
    } 
     delay(2000);
}
//----------------------------------------------
//----------------------------------------------
void switchInterruptHandler()
{
  static unsigned long last_interrupt_time = 0;
  unsigned long interrupt_time = millis();
  // If interrupts come faster than 200ms, assume it's a bounce and ignore
  if (interrupt_time - last_interrupt_time > debounceTime)
  {
    // various opearations based on state
    switch (operatingState) 
    {
      case (1) :
        operatingState = 2;
      break;
      case (2) :
      	operatingState = 3;
      break;
      case (3) :
      	operatingState = 4;
      break;
      case (4) :
      	operatingState = 1;
      break;
    }
  last_interrupt_time = interrupt_time;    
  }
  else
  {
    //return FALSE;
  }
}

//----------------------------------------------
//----------------------------------------------
void flashLED(int number) 
// just to test the led is working
{
 for(int i=0; i<number; i++)
 {
 digitalWrite(9, LEDOn);   // set the LED to alternate
 LEDOn = !LEDOn;
 delay(100);
 }
 digitalWrite(9, 0);
}
