/*
Read from Com [Arduino]; Write to text file
Stu Sontier 14-8-2012
Based on arduinobasics 'displaying serial data from arduino' this sketch reads from the arduino com port (manually set, below).
It uses serial event to grab lines of data.
While there is data which is not End of File, it checks that there are at least 5 parts to each data line (number, lat, lng, speed, heading)
From this data it creates (or overwites) a json formatted text file in the same folder as the sketch.
When it sees EOF indication, it closes the json dataset.
*/


//http://arduinobasics.blogspot.co.nz/2011/06/displaying-serial-data-from-arduino-uno.html
/*
Here is a very basic Processing Sketch that will allow you 
to receive data from the Serial port attached to the Arduino 
and display the reading on your computer screen. In my case, 
the Arduino is connected to COM13. You may need to change this
if you decide to follow in my footsteps.

You will need to setup an Arduino sketch to send serial data 
to the computer using a Serial.println(value) command. 
The processing sketch will look for the line feed character 
' \n' coming from COM13, which will trigger a serialEvent(). 
You can get processing to look for another character if you 
want to: just change the character within the bufferUntil() 
command.
﻿The draw() method is made redundant because the screen 
updating is handled by the serialEvent() in response to 
serial data communication with the Arduino UNO
*/
import processing.serial.*;
Serial myPort;
String coordString="";
PFont font;
PrintWriter output;
String fileName;
int lf = 10;      // ASCII linefeed
int countLines = 0;
String json = "";
String jsonStart = "var coordsJS = [";
String jsonStop = "]";
boolean serialEventHappened = false;
long fileLength = 0;          // for counting the byte length of received data

void setup() {
  size(600,405);
  writeText("Starting");
  myPort = new Serial(this, "COM4", 57600);  // comm port for arduino - change to match the comm port that is given by the OS to the arduino hardware
  //myPort.bufferUntil('\n');
  font = createFont(PFont.list()[2],16);
  textFont(font);
  fileName = "arduino_data";
  output = createWriter(fileName + ".js"); // save the file in the sketch folder
  output.println(jsonStart);
}
//-----------------------------------

//-----------------------------------
void draw() {
  //The serialEvent controls the display so nothing to do here

  
}  

//-----------------------------------

//-----------------------------------
void serialEvent (Serial myPort){
  //serialEvent is fired when serial data is available. It is buffered until \n as above (myPort.bufferUntil)
  // Note - no real error checking in here at this point
 coordString = myPort.readStringUntil('\n');
 //testFirst.indexOf("filesize")
 countLines += 1;
  if(coordString != null){
    coordString=trim(coordString);
    fileLength += coordString.length();
    // look for 'end of transmission' indicated by the presence of the text "filesize"
    if (coordString.indexOf("filesize")!=-1)  
      {
        // if string "filesize" is seen, this is the end of the transmission so close the json file
        output.println(jsonStop);
        String[] filesizeStringArray = split(coordString, "filesize:-- ");
        output.flush();
        writeText2("expected length = " + filesizeStringArray[1], 10, 4);
        writeText2("counted length = " + fileLength, 15, 3);
        

      }
    else 
      {
        // if string "filesize" is not seen, write stuff to window
        text("\nline = " + coordString, 50, 90+countLines*2);
      }

    text("\navail: " + myPort.available(), width/20, height/3);

    String[] coordStringArray = split(coordString, ", ");
    //
    // if all parts of the string are available:
    if(coordStringArray.length>4) 
      {
        json = "{number: \"" + coordStringArray[0] + "\",lat: \"" + coordStringArray[1] + "\",lng: \"" + coordStringArray[2] + "\",speed: \"" + coordStringArray[3] + "\",heading: \"" + coordStringArray[4] + "\"},";
        output.println(json);
        output.flush(); // Write the remaining data
        //output.close(); // Finish the file
      }
  
  }
}
//-----------------------------------

//-----------------------------------
void writeText(String textToWrite){
  background(255);
  fill(0);
  text(textToWrite, width/20, height/2);   
}
//-----------------------------------

//-----------------------------------
void writeText2(String textToWrite, int wid, int pos){
// write to window
  text(textToWrite, width/wid, height/pos);   
}

